;; This buffer is for notes you don't want to save, and for Lisp evaluation.
;; If you want to create a file, first visit that file with C-x C-f,
;; then enter the text in that file's own buffer.
;; C/C++ p̃JX^}CY
(defconst my-c-style
  '(
    ;; {ItZbgʂ̐ݒ
    (c-basic-offset             . 4)

    ;; tab L[ŃCfgs
    (c-tab-always-indent        . t)

    ;; Rgs̃ItZbgʂ̐ݒ
    (c-comment-only-line-offset . 0)

    ;; JbRO̎s̐ݒ
    (c-hanging-braces-alist
     . (
        (class-open before after)       ; NX錾'{'̑O
        (class-close after)             ; NX錾'}'̌
        (defun-open before after)       ; ֐錾'{'̑O
        (defun-close after)             ; ֐錾'}'̌
        (inline-open after)             ; NX̃CC
                                        ; ֐錾'{'̌
        (inline-close after)            ; NX̃CC
                                        ; ֐錾'}'̌
        (brace-list-open after)         ; 񋓌^Az錾'{'̌
        (brace-list-close before after) ; 񋓌^Az錾'}'̑O
        (block-open after)              ; Xe[gg'{'̌
        (block-close after)             ; Xe[gg'}'O
        (substatement-open after)       ; TuXe[gg
                                        ; (if )'{'̌
        (statement-case-open after)     ; case '{'̌
        (extern-lang-open before after) ; ւ̃P[W錾
                                        ; '{'̑O
        (extern-lang-close before)      ; ւ̃P[W錾
                                        ; '}'̑O
        ))

    ;; RO̎s̐ݒ
    (c-hanging-colons-alist
     . (
        (case-label after)              ; case x':'̌
        (label after)                   ; x':'̌
        (access-label after)            ; ANZXx(public)':'̌
        (member-init-intro)             ; RXgN^ł̃o[
                                        ; Xg̐擪':'ł͉sȂ
        (inher-intro before)            ; NX錾ł̌pXg̐擪
                                        ; ':'ł͉sȂ
        ))

    ;; }ꂽ]vȋ󔒕̃LZ̐ݒ
    ;; L*폜
    (c-cleanup-list
     . (
        brace-else-brace                ; else ̒O
                                        ; "} * else {"  ->  "} else {"
        brace-elseif-brace              ; else if ̒O
                                        ; "} * else if (.*) {"
                                        ; ->  } "else if (.*) {"
        empty-defun-braces              ; ̃NXE֐`'}' ̒O
                                        ;G"{ * }"  ->  "{}"
        defun-close-semi                ; NXE֐`';' ̒O
                                        ; "} * ;"  ->  "};"
        list-close-comma                ; z񏉊'},'̒O
                                        ; "} * ,"  ->  "},"
        scope-operator                  ; XR[vZq'::' ̊
                                        ; ": * :"  ->  "::"
        ))

    ;; ItZbgʂ̐ݒ
    ;; Kv̂ݔ(̐ݒɕtĂ info Q)
    ;; ItZbgʂ͉LŎw
    ;; +  c-basic-offset 1{, ++ c-basic-offset 2{
    ;; -  c-basic-offset-1{, -- c-basic-offset-2{
    (c-offsets-alist
     . (
        (arglist-intro          . +)   ; Xg̊Jns
        (arglist-close          . c-lineup-arglist) ; Xg̏Is
        (substatement-open      . 0)    ; TuXe[gg̊Jns
        (statement-cont         . +)   ; Xe[gǧps
        (statement-block-intro	. +)
        (case-label             . 0)    ; case ̃xs
        (label                  . -)    ; xs
        (block-open             . 0)    ; ubN̊Jns
        (member-init-intro      . +)   ; oIuWFNg̏Xg
        (cpp-macro				. -)
        (inline-open			. 0)
        (string					. +)
        (extern-lang-open		. 0)
        ))

    ;; Cfgɍ\͏\
    (c-echo-syntactic-information-p . t)
    )
  "My C Programming Style")

;; hook p̊֐̒`
(defun my-c-mode-common-hook ()
  ;; my-c-stye o^ėLɂ
  (c-add-style "PERSONAL" my-c-style t)

  ;; ̃X^CftHgŗpӂĂ̂őIĂ悢
;  (c-set-style "gnu")
;  (c-set-style "cc-mode")
;  (c-set-style "stroustrup")
;  (c-set-style "ellemtel")
  ;; ̃X^CύXꍇ͎̂悤ɂ
;  (c-set-offset 'member-init-intro '++)

  ;; ^u̐ݒ
  (setq tab-width 4)

  ;; ^ȗɃXy[Xg
;  (setq indent-tabs-mode nil)

  ;; s(auto-newline)Lɂ
  (c-toggle-auto-state t)

  ;; A󔒂̈ꊇ폜(hungry-delete)Lɂ
  (c-toggle-hungry-state t)

  ;; Z~RŎsȂ
  (setq c-hanging-semi&comma-criteria nil)
  
  (setq c-strict-syntax-p t)
  )
;; [hɓƂɌĂяo hook ̐ݒ
(add-hook 'c-mode-common-hook 'my-c-mode-common-hook)

;; wb_t@Cc++[hŊJ 
(setq auto-mode-alist (append
                       '(("\\.h$"    . c++-mode))
                       auto-mode-alist))
(c++-mode)
(mark-whole-buffer)
(c-indent-line-or-region)

(save-buffer)
;;(save-buffers-kill-emacs)
