%global qtver 6.8
%global kdever 4.3

Name: kame

%{!?build_nidaqmx: %define build_nidaqmx 1}

Version: 7.5.0
Release: 1
License: GPL
Group: Applications/Engineering
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: qt >= %{qtver}, kdelibs >= %{kdever}
Requires: libart_lgpl, gsl, zlib, ruby, libtool-ltdl, fftw
Requires: libgfortran, atlas-sse2
Requires: oxygen-icon-theme
BuildRequires: ruby, ruby-devel, gsl-devel, boost-devel, libtool, libtool-ltdl-devel, fftw-devel
BuildRequires: gcc-gfortran, atlas-sse2-devel
BuildRequires: libidn-devel
BuildRequires: qt-devel >= %{qtver}, kdelibs >= %{kdever}, kdelibs-devel >= %{kdever}
BuildRequires: zlib-devel, libpng-devel, libjpeg-devel
BuildRequires: gcc-c++ >= 10.0
#BuildRequires: clang >= 2.9

Source0: %{name}-%{version}.tar.bz2

Summary: KAME, K's adaptive measurement engine.

%description
K's adaptive measurement engine. 

%package modules-standard
Group: Applications/Engineering
Summary: KAME, K's adaptive measurement engine. Modules.
Requires: kame = %{version}
Requires: linux-gpib
BuildRequires: linux-gpib-devel
%description modules-standard
K's adaptive measurement engine.
Many standard drivers.

%package modules-nmr
Group: Applications/Engineering
Summary: KAME, K's adaptive measurement engine. Modules.
Requires: kame-modules-standard = %{version}
%description modules-nmr
K's adaptive measurement engine.
NMR drivers.

%if 0%{build_nidaqmx}
%package modules-nidaq
Group: Applications/Engineering
Summary: KAME, K's adaptive measurement engine. Modules.
Requires: kame-modules-nmr = %{version}
Requires: nidaqmxef
BuildRequires: nidaqmxcapii
%description modules-nidaq
K's adaptive measurement engine.
NMR drivers.
%endif

%prep

%setup -q
export CXX="g++ -g3 -O2 -mfpmath=sse -msse -msse2 -mmmx -march=pentium4 -D__sse2__"
#export CXX="clang++ -g -O4 -march=pentium4 -D__sse2__"
%cmake #-DCMAKE_BUILD_TYPE=Debug


%build
make

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
#if [ -f $RPM_BUILD_ROOT/%{_bindir}/*-kame ]
#then
#	mv $RPM_BUILD_ROOT/%{_bindir}/*-kame $RPM_BUILD_ROOT/%{_bindir}/kame
#fi
%if !0%{build_nidaqmx}
	rm -f $RPM_BUILD_ROOT%{_libdir}/kame/modules/libnidaq*
%endif

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/udev/rules.d
cat <<EOF > $RPM_BUILD_ROOT%{_sysconfdir}/udev/rules.d/10-kame.rules
KERNEL=="ttyUSB*", GROUP="uucp", MODE="0666"
KERNEL=="ttyS*", GROUP="uucp", MODE="0666"
EOF

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_bindir}/kame
%{_datadir}/applications/kde4/*.desktop
%{_datadir}/kde4/apps/kame
%{_datadir}/icons/*/*/apps/*.png
%{_datadir}/locale/*/LC_MESSAGES/*.mo
%{_datadir}/doc/HTML/*/kame
%{_libdir}/kame/modules/libtestdriver*
%{_libdir}/kame/modules/libmontecarlo*

%files modules-standard
%{_sysconfdir}/udev/rules.d/10-kame.rules
%{_libdir}/libkame_charinterface*
%{_libdir}/libkame_dcsourcecore*
%{_libdir}/libkame_dmmcore*
%{_libdir}/libkame_dsocore*
%{_libdir}/libkame_magnetpscore*
%{_libdir}/libkame_levelmetercore*
%{_libdir}/libkame_networkanalyzercore*
%{_libdir}/libkame_motorcore*
%{_libdir}/libkame_flowcontrollercore*
%{_libdir}/kame/modules/libcounter*
%{_libdir}/kame/modules/libdcsource*
%{_libdir}/kame/modules/libdmm*
%{_libdir}/kame/modules/libdso*
%{_libdir}/kame/modules/libfuncsynth*
%{_libdir}/kame/modules/liblia*
%{_libdir}/kame/modules/libmagnetps*
%{_libdir}/kame/modules/libtempcontrol*
%{_libdir}/kame/modules/liblevelmeter*
%{_libdir}/kame/modules/libnetworkanalyzer*
%{_libdir}/kame/modules/libfourres*
%{_libdir}/kame/modules/libmotor*
%{_libdir}/kame/modules/libflowcontroller*
%{_libdir}/kame/modules/libqd*

%files modules-nmr
%{_libdir}/libkame_nmrpulsercore*
%{_libdir}/libkame_sgcore*
%{_libdir}/kame/modules/libnmr*
%{_libdir}/kame/modules/libsg*
%{_libdir}/kame/modules/libthamway*

%if 0%{build_nidaqmx}
%files modules-nidaq
%{_libdir}/kame/modules/libnidaq*
%endif

#the following will be copied from the separated file ChangeLog.
%changelog
* Mon Dec 22 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.5.0-1)
- Graph: fix for cheap intel integrated graphics. GLselect no longer used. Changing to color picking technique.

* Sun Dec 14 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.4.0-1)
- Win32: default compiler is now changed to clang++, with llvm-mingw64 build of Qt.
- win32-clang-g++: use dllexport instead of export-all-symbols.
- Fujikin MFC: suppressing communication errors for recent MFC.
- SI930* temp. monitor.: experimental yet.
- Ruby: fix for possible crash after touch().
- ODMR: many improvements and 2D imaging.
- Prologix: putting waits for better stability.

* Wed Oct 15 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.3.1-1)
- Fix for thread safety regarding math tools.
- Lakeshore 218 temp monitor
- Many improvements on ODMR

* Tue Jul 29 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.3.0-1)
- Displays fitted curves for math tools.
- Fix for compilation issues with some versions of pybind11 and ruby.
- Many improvements on digital camera and ODMR

* Tue May 27 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.5-1)
- Improved terminating procedure/close menu behavior.
- Fix for Prologix GPIB for drivers without serial poll.
- Scanner variants for Lakeshore 370/372
- better channel configs in Lakeshore 350/370/372
- Fix for status update in PROT.

* Wed Apr 2 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.4-1)
- 7.2.3 may crashe in race condition.

* Tue Jan 28 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.3-1)
- 7.2.2 crashes in win32.

* Sat Jan 25 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.2-1)
- hyperlinks in IPython messages.
- Better icons.

* Mon Jan 20 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.1-1)
- Redirecting stdout/err to display area in notebook.

* Sun Jan 19 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.2.0-1)
- The first MDI child window is now for IPython.

* Sat Jan 18 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.8-1)
- Binding for Jupyter notebook.

* Sat Jan 18 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.7-1)
- Fix for stdio behvior of python line interpreter.

* Wed Jan 15 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.6-1)
- Support for IPython kernel and popen for Jupyter console/qtconsole.

* Sat Jan 11 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.5-1)
- Fix for 4-terminal method.
- Python driver: 4-terminal method with multi-setting.

* Tue Jan 7 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.4-1)
- Fix for mathtool and multi-entry support
- pdb can be used under the terminal
- Python driver: 4-terminal method.

* Thu Jan 2 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.3-1)
- Ruby 3.1 works well with mac(in debug mode) and mingw64.

* Wed Jan 1 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.2-1)
- Fix for init. issue in ruby >= 3., fine with 3.3 in Mac.
- Ruby 3.1 works with mingw64 when launched from Qt creator.
- Selectable scripting shell.

* Wed Jan 1 2025 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.1.0-1)
- Compiles with ruby 3.3. Works with 3.2 in Mac.
- Python scripting for several drivers, 1D/2D Math tools.

* Sat Nov 23 2024 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.0.2-1)
- Fix for terrible bug.

* Fri Nov 22 2024 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (7.0.0-1)
- Python scripting is now possible. 
- Prologix GPIB-USB controler, set default for GPIB when NI488.2 is not found.
- Fix for bugs in JAI.
- Experimental: Lakeshore M81

* Thu Oct 17 2024 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (6.1.1-1)
- Euresys: fix for startup

* Sun Oct 6 2024 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (6.1.0-1)
- CopperMountain: fix for byte order issue for newer revisions.
- Oriental Motor CVD2B/5B STM drivers
- Filter wheel driver and color imager
- Fix stability/usablitiy for math tools
- Fix for digital camera, text collapse issue, aspect ratio issue
- Ruby pressure scales for optical specrometer
- Ocean insight/optics USB4000
- Sigma optics PAMC104 piezo motor driver
- (experimental) LDC-37**, LDX-32**, Euresys eGrabber, Optotune ICC4C2000

* Tue Dec 19 2023 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (6.0.0-1)
- Runs with mingw64.
- Fix for message window in win32.
- Firewire digitalcameras in maxosx.
- ODMR staffs.
- Math tools on graphs. ex. center of gravity.
- NMRPulse: displays areas for calculations
- SG: more modulation features for agilent E-series SGs.
 
* Tue Jun 27 2023 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8.6-1)
- foures: bug fix for multi channel simultaneous measurement

* Sun Jun 25 2023 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8.5-1)
- LXI3390: starts working
- foures: bug fix regarding XTime (implicit bool to double)
- compiles with recent mingw32
- autolctuner: supports preset values

* Mon Jun 12 2023 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8.4-1)
- E44xB SCPI SG
- Experimental: ODMR
- LivreVNA
- Staged autotuner
- Experimental: Coherent Stingray
- LXI 3390
- nmrfspectrum: bug fix

* Fri Dec 9 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8.3-1)
- DAQmxPulser: fix bug happened @5.8.2
- Signal Recovery 7260 lockin amp
- LIA: improve wait strategy
- FlexAR: fix init. issue.

* Sun Nov 13 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8.2-1)
- NMRPulser: signals for ODMR
- ThamwayUSB: improved initialization process
- autotuner: fix bugs after ver5.6
- twoaxis: Fix for race condition
- fix compilation with old compilers.

* Mon Oct 17 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.8-1)
- OceanOptics/Seabreeze HR2000+/4000 optical spectromters
- Thamway: Worked with M1 mac. USB routines shared w/ oceanoptics.
- CAM: several fixes.
- Interfaces: fix bugs after STOP

* Sat Jun 25 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.7.1-1)
- DMM: support for multi channels, Keithley 2851, 2700.
- CAM: better UI

* Thu Jun 9 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.7-1)
- CAM: fixed bugs.

* Thu May 19 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.6-1)
- Flex AR: Support of pushing mode. Fix bug for STOP button.
- CAM: CAM using STMs.

* Sat Apr 16 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.5.2-1)
- NIDAQmx: PCIe-6374/6376 experimental support

* Sun Feb 13 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.5.1-1)
- Mac: Universal binary ready
- thamway: fix bug on loading libusb

* Sun Feb 13 2022 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.5-1)
- Native arm support for M1 Mac

* Tue Dec 28 2021 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.4-1)
- worked w/ C++17 and Qt 6 w/ Qt5 compatibility module
- graph: 3D viewpoint can be reset by clicking right button.
- magnetps: Fix behavior for sweep rate during persistent mode
- TempControl: Fix behavior for "stabilized" value regarding "I"
- NMR: tSVD fourier spectral analysis (experimental) 

* Sun Dec 20 2020 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.3.2-1)
- NMRT1: Fix for "Flatten generator", behavior near P1Max.
- AutoLCTuner: improved strategy during tuning
- Fix for threading on starting a driver
- Fix for MonteCarlo

* Sun Apr 26 2020 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.3.1-1)
- Pfeiffer TPG361/362 Gauge (RS485). 

* Sun Dec 1 2019 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.3-1)
- Density mapping for T1,T2 by Tikhonov regularization. 

* Fri Sep 6 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.2.2-1)
- Workaround for Qt5.12
- NMREcho: Fix for background warning, new warning against large voltage.
- NMRT1: T2 measurement by CPMG
- ThamwayRealtimeDSO: Fix for trigger position
- new driver: two-axis goniometric stage

* Sun Nov 25 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.2.1-2)
- Mac: Fix for text/draw collapse on MDI windows.

* Sat Nov 24 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.2.1-1)
- Mac: Workaround for huge memory (pseudo) leakage with QLabel/QLineEdit.  
- NMRFSpectrum: fix for saving time

* Wed Nov 21 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.2.0-1)
- Mac: userside memory allocator is introduced again.
- Mac: repairs Info.plist and icon.
- Better window initial positions when it appears.
- Thamway: libusb support is improved in mac.
- Thamway: QAM works fine now.
- Autolctuner: fiting improved, compatible with Flex AR.
- Copper Mountain TR1300/1,5048,4530 Network Analyzer
- Lakshore 350: Fix for prop. setting.

* Mon Sep 17 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.1.5-1)
- Pfeiffer Turbo molecular pump controller TC110 
- Autolctuner: fiting improved.
- VNWA3E TCP/IP interface for recent firmwares.
- pulseanalyzer: obsolete

* Wed Jun 27 2018 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.1.4-1)
- Compatible with Qt-5.11
- Fixed bug for formatprint with threads.

* Mon Oct 16 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.1.3-1)
- Compatible with OSX High Sierra
- thamwayrealtimedso: improved stability.
- qdppms: better slow sweep.
- Agilent/HP4282A LCR meter.

* Wed Aug 16 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.1.2-1)
- nmrpulser: improved stability for softtrigerring
- lcautotuner: better behavior
- graphlist: fox for multiple creation
- xwavengraph: appropriate precisions for waves, threaded dumping.
-KE6482 picoam meter

* Fri Jul 14 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.1.0-1)
- Floating tool boxes.
- NMR: Autotuner becomes much better.
- gsl >= 2 is required for better fitting.

* Fri Jun 23 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.0.1-1)
- Thamway USB: minor fix for PROTII.

* Thu Jun 22 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (5.0.0-1)
- interface: starting is handled by thread.
- graph: theme colors, night, daylight. Night is default.
- graph: rewrote persistent view.
- ppms: software slow ramp rate for field. fix for units.
- usb: async. transfer is default for bulk transfers.
- nmr: fix for clear behavior.
- Thamway: many fixes for PROT3.
- Thamway USB: init. of FX devices are deferred.
- thamwaypuler: fix for startup behavior
- ruby: displays sleeping status
- ruby: timestamp of stdout/err.
- ruby: SAFE=1 is abondoned due to 777 permission folders. 

* Wed May 10 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.3.0-1)
- stdout/err log into a file during execution of script.
- nmrpulsercore: Fix initial values for spin boxes.
- Thamway PROT3 compatibility (experimental)
- Thamway USB devices operated also with cyusb3.sys
- Thamway QAM pulser.
- (experimental) Real-time DSO for digital demodulation.

* Thu Jan 19 2017 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.8-1)
- Lakeshore 350 temp. controller

* Fri Dec 9 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.7-1)
- ezusb: works well in OSX
- OSX: disables AppNap and machine sleep.

* Fri Nov 11 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.6-1)
- Enables NI488.2, and USB interfaces for thamway instruments on OSX
- xtime.cpp: Gets rid of spin lock again.
- thamwaydso: Fixed for channel names and init. valuse of records, timewidth.
- Now compiles with GSL > 2.0
- OSX: uses standard glu.h

* Sun Nov 6 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.5-1)
- Fixed unstability that appeared as of 4.2.1, regarding memory leaks of dwm
- Fixed priority issue for test driver.

* Sun Nov 6 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.4-1)
- Reduces CPU usgae

* Fri Sep 2 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.3-1)
- NIDAQDSO: Fix for changes made at 4.2.2
- NIDAQ: can be placed directly at C:\

* Thu Sep 1 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.2-1)
- DSO using Digilent Waveform

* Sun Aug 7 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.1-1)
- Roll backs some of buggy transaction.h from 4.1.14.
- Repainting strategy of graph is improved.
- Refactors signals.
- Fix bugs for f-sweep NMR specrtrum regarding autotuning.

* Wed Aug 3 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.2.0-1)
- Fix severe bugs regarding SSE on mingw32. adds -mstackrealign compile option.
- Uses QOpenGLWidget for QT > 5.4 instead of the obsolete QGLWidget. Adds -lopengl32 -lglut32 for mingw32.
- Abondons nooverpaint/nodirectrender options.
- Refactors signal/slot.

* Wed Jul 27 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.16-1)
- Fix severe bugs for 4.1.14 and 15. (note: not fixed yet)

* Feb Jul 12 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.15-1)
- nmrfspectrum: Cyclic sweep mode.
- Faster transaction.
- nmrrealx: Tracks peak freq.

* Wed Jun 29 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.14-1)
- std::atomic of mingw is buggy? Back to the original one.

* Thu Jun 23 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.13-1)
- Faster transaction.
- OrientalMotor Flex: better recovery from errors.
- QD PPMS: adds controls.
- nmrspectrum: reads field values from QD PPMS.

* Thu Mar 10 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.12-1)
- QD PPMS monitor: adds user temp
- dcsource: scalar entry.

* Sun Feb 7 2016 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.11-1)
- xwavengraph: avoids IO during dumping transaction.
- QD PPMS monitor

* Sun Sep 13 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.10-1)
- Baudrate for Modbus RTU (Flex AR/CRK) is defaulted to 57600bps.
- OMRON E5*C controller via Modbus RTU.

* Tue Aug 18 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.9-1)
- Fix chart.
- Fix for old LS340.

* Fri Jun 19 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.8-1)
- Space as delimiter for text files, again.
- Faster XXYPlot.

* Fri Jun 19 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.7-1)
- Tab as delimiter for text files.

* Wed Jun 17 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.6-1)
- revives gpib_reset() for oxford.

* Mon Jun 15 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.5-1)
- Rewrites XCharInterface

* Thu Jun 11 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.4-1)
- Allows retrys for fujikinprotocol.
- Fix for behavior during stopping interface.
- Fix for NI DSO that has more than 2 channels.

* Sat Jun 6 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.3-1)
- Gas flow contorl for ITC503
- Suppresses error messages from gsl.
- Fix for SerialEOS.

* Thu May 28 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.2-1)
- Fix for Non-latin1 filepaths
- Fix for Cry-o-con M62 RS232

* Tue May 26 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.1-1)
- Fix for Cryo-o-con M62 with early firmware.
- LR-600 (experimental)

* Mon May 18 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.1.0-1)
- Fix for Cryogenic SMS ver 7
- Fix for Windows Serial Ports
- Fix for OS X Yosemite
- Fix for window focus on WIndows
- NMRPulse: makes lines conc colored
- NIDAQmxpulser: Suppresses error while stopping GateCtr for Pausing Bit.

* Fri Apr 17 2015 Kentaro Kitagawa <kitagawa@phys.s.u-tokyo.ac.jp>
- (4.0.14-1)
- Fix for SG SML
- Fix for NQR I=9/2 relax. function

* Fri Oct 3 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.12-1)
- Fix for PROT/USB pulser.
- Fix for AgilentE5061

* Sun Aug 31 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.11-1)
- Wraps ruby.h
- LoadLibararyA() instead of libtool for win.

* Thu Aug 28 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.10-1)
- Much faster transactions.
- NMR:Tune strategy for fspectrum
- NMRT1: fix for autophase.

* Sun Aug 24 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.9-1)
- Fix for atomic ops.
- launching kame now possible with MSVC
- Fix for PROT.
- Enables SSE2 for mac/win.
- Fix for NIDAQ under win.

* Wed Aug 20 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.8-1)
- enables overpaint by default

* Wed Aug 20 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.7-1)
- Thamway NMR PROT built-in signal generator (USB/TCP)
- Thamway NMR pulser PG series (USB/GPIB/TCP)
- Thamway A/D conversion board DV14U25 (USB) 
- Fix Lecroy DSO communications.
- XCustomCharInterface

* Sun Aug 17 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.6-1)
- Overpaint option for OpenGL
- Improved i18n for QT
- Sophisticated font size for graphs.
- Win32 build becomes free from boost.

* Mon Aug 11 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.5-1)
- Beta 5
- Thamway impedance analyzer
- R&S SML/SMV signal generator

* Sun Aug 10 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.4-1)
- Beta 4
- Works with windows binary.

* Fri Aug 8 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.3-1)
- Fix for daqmxpulser.
- Keepalive TCP and fix for signals.

* Wed Aug 6 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.2-1)
- Fix for sliders.
- GUI looks better.

* Sun Aug 3 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.1-1)
- Fix for XTime(Win).
- Tcp/IP for win.
- Message window.

* Fri Aug 1 2014 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (4.0.0-1)
- Beta 1
- Windows/MacOSX builds without Qt nor FTGL.

* Sat Jul 28 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.7-1)
- autotuner: Improved.

* Thu Apr 25 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.6-2)
- nmrpulser: On-line start/stop to keep coherency to DSO, when Digital RF is on.
- nidaqdso.cpp: bug fix for pulser creation. 

* Fri Mar 8 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.5-1)
- secondarydriverinterface: does negotiation.
- flowcontroller: valves gets working.
- serial, levelmeter: supports echo backs.

* Tue Feb 19 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.4-1)
- autotuner: better tuning.

* Sun Feb 17 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.3-1)
- charinterface: changes default EOS from serial to LF.

* Sat Feb 16 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.2-3)
- Better autolctuner.
- Fix for Cryocon M32/62.

* Tue Feb 12 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.1-1)
- Along with clang++.
- Much faster .kam loading. (isThreadSafeDuringCreationByTypename()) 

* Sun Feb 10 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.3.0-1)
- textwriter: logger.

* Sat Feb 9 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.23-1)
- nmrrelax: Flatten P1 distribution.
- nmrrelax: Modifies fitting initialization.

* Tue Feb 5 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.22-1)
- autolctuner: works better.
- flowcontroller: Fujikin FCST1000 mass flow controllers.

* Sun Feb 3 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.21-1)
- tempcontrol: multi-loops.

* Sat Feb 2 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.20-1)
- xnode.h: avoids double signals in str().

* Thu Jan 17 2013 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.19-1)
- usertempcontrol: LakeShore 370.

* Wed Dec 19 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.18-1)
- nmr: Freq. sweep w/ autolctuner.
- sg: DSTech. DPL-3.2XGF

* Wed Nov 14 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.17-1)
- TCP/IP interface.
- DG8SAQ VNWA3E/Custom Network Analyzer.

* Tue Oct 30 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.16-1)
- AutoLCTuner.

* Sun Oct 7 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.15-1)
- Improves stability.

* Sat Sep 8 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.14-1)
- Popups msg when it fails to open file.
- Improves stability.

* Sun Jul 15 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.13-1)
- motor: ORIENTALMOTOR FLEX CRK/AR/DG2.
- graphpaintergl: includes <GL/glu.h>

* Wed Jul 11 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.12-1)
- fourres: Resistance mesasurement with switching polarity method.
- dcsource: ADVANTEST TR6144/R6142/R6144.

* Tue Jun 12 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.11-1)
- usermagnetps.cpp: For Cryogenic SMS ver 4.

* Fri Jun 8 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.10-1)
- pulseanalyzer: Fix bug. during off state.
- graph, chart: Incresing maxcount, and do not clear after changing it.

* Tue May 15 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.9-1)
- magnetps: Oscillating approach.

* Sun May 13 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.8-1)
- magnetps: Limit rates, Secondary PS, safe conditions.

* Sat May 12 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.7-1)
- counter: Mutoh counter.
- tempcontrol: Keithley 2700/7700.
- recoder.cpp: Fix bug that previous values are written to last line.

* Thu Apr 26 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.6-1)
- userlockinamp: NF LI5640

* Thu Apr 26 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.5-1)
- pulserdrivernidaqmx: Fix for non-thread-safe startup.

* Wed Apr 25 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.4-1)
- counter: Mutoh Digital Counter NPS, for encoders.

* Sat Apr 21 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.3-1)
- pulseanalyzer: NMR Built-in Network Analyzer using Pulse Analyzer mode.
- secondarydriverinterface: avoid multiple delegates.

* Fri Apr 20 2012 Kentaro Kitagawa <kitag@kochi-u.ac.jp>
- (3.2.2-1)
- usermagnetps: Cryogenic SMS.
- pulsercore: Pulse Analyzer mode.

* Sat Feb 25 2012 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.2.1-1)
- main.cpp: Adds error handler for GSL.

* Wed Oct 12 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.2.0-1)
- nmrpulser: Checks sanity of P1.
- nmrrelax: Does not skip when previous P1 is out of range.
- nmrpulse: Fix for the issue that scalar entries were based on previous dataset.  
- Fix for strange std::fill behavior for complex classes in clang++. 

* Thu Sep 29 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.96-1)
- Partially uses c++0x.
- Support for clang++.
- Shared libraries are now moved to the system default location (works fine with MacPorts).

* Mon Jul 11 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.14-1)
- pulsedriver: anti-alias for AO.
- pulsedrivernidaqmx: ring buffer and integrated AO/DO buffering.

* Thu Jul 7 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.15-1)
- Fixed icon references.

* Thu Jul 7 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.12-1)
- pulsedrivernidaqmx: refined pulse generation.

* Mon Jul 4 2011 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.10-1)
- for Fedora 14

* Fri Sep 10 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.9-1)
- for Fedora 13

* Tue Jun 8 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.7-1)
- nidaqdso.cpp: Fix buffer size for recent computers.
- xwavengraph.cpp: Fix for possible crash.

* Fri Jun 4 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.5-1)
- nidaqmxdso.cpp: fix for recent machines.

* Thu Apr 29 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.4-1)
- allocator.cpp: fixed-/variable-size lock-free allocators for less than 4KiB.

* Sun Apr 18 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.3-1)
- allocator.cpp: Lock-free new()/delete() by memory pools.
- atomic_shared_ptr.h: Faster local_shared_ptr.
- xschedular.h, transaction_signal.h: Suppress unnecessary events also for the main thread when AVOID_DUP flag is set.

* Mon Apr 12 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.2-1)
- analyzer.cpp: Fix for XValGraph.
- Get rid of obsolete functions.

* Fri Apr 9 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.1-1)
- No more mask/unmask for Talker/Listener.
- puserdrivernidaqmx.cpp: Surpress warning during stopPulseGen().
- nmrspectrumbase_impl.h: Fix for coarse resolution.
- transaction_signal.h: Fix memory leaks.
- graph.cpp: Fix auto frequency for axes.

* Wed Apr 7 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.1.0-1)
- transaction.h, xnode.h: Apply lock-free software transactional memory to most of all internals.

* Wed Jan 6 2010 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (3.0.0-1)
- dso.cpp, nmrpulse.cpp: Averaging restarts when a clear button is invoked.
- pulserdriver.cpp: Fix phase cycling for a stimulated echo. 
- The first stable release for 3.0.

* Mon Dec 14 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.8-1)
- gpib.cpp: Fix for NI488.2.

* Fri Nov 27 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.7-2)
- graphpaintergl.cpp: Fix drawing strategy for mac.

* Sun Nov 22 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.7-1)
- Portfile for MacPorts.
- now NI488 can be also used as a GPIB driver.
- x86_64.
- graphpaintergl.cpp: uses QString::toWCharArray instead of the complex iconv().

* Wed Nov 11 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.6-1)
- recordreader.cpp: changes # of threads to 1 for reading records.

* Mon Nov 2 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.5-1)
- Gets rid of XRawThermometer.

* Sat Oct 31 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.4-1)
- Lakeshore340: reading of raw sensor values.

* Thu Oct 29 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.3-1)
- Rearrange UI designs.

* Wed Oct 28 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.1-1)
- No more interval in QTimer's event during processing the main-thread envents.

* Thu Oct 22 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.9.0-1)
- The first working version with Qt4/Kde4.
- cmake.
- Core modules are moved to modules/core.
- Rearranged UIs.

* Fri Oct 16 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.26-1)
- Fix bug in atomic operations.

* Sat Apr 25 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.25-1)
- The first release for Fedora 10.
- dso.cpp, nidaqdso.cpp: Fix for the case where no trace is selected.

* Sat Mar 14 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.24-1)
- nmr: convolute dark PSD by rect window.

* Fri Mar 13 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.23-1)
- nmr: calculate dark side (PSD of noise inferred from background).

* Sat Mar 7 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.22-1)
- nmrspectrumbase: selectable bandwidth.

* Thu Mar 5 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.21-1)
- nmr: clear averaging buffers on starting secondary measurement.
- nmrpulse: check multi-echo settings.
- nmrpulse: solver can be chosen for periodic noise reduction.

* Sat Feb 14 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.20-1)
- pulserdriver.cpp: phase cycle, now 4-cycle available for multiple/stimulated echo sequence.

* Sat Jan 3 2009 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.19-1)
- nmrspectrumbase.cpp: Fix weighting.

* Thu Oct 17 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.18-1)
- dso.cpp: Fix for reading errors.
- lecroy.cpp: Increase timeout.

* Tue Sep 23 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.17-1)
- nmrspectrumbase.cpp: Get rid of noisy parts.
- nmrpulse.cpp: Improve multiecho.

* Fri Sep 12 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.16-1)
- nmrspectrumbase.cpp: Improve autophasing.

* Wed Sep 10 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.15-1)
- nmrfspectrum.cpp: Burst mode.

* Wed Sep 10 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.14-1)
- nmrspectrumbase.cpp: Fix bugs.

* Thu Sep 4 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.13-1)
- freqestleastsquare.cpp: Faster estimation.

* Sun Aug 31 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.12-2)
- math: For IC, detection of number of data points in frequency domain.

* Wed Aug 29 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.12-1)
- nmr, math: Frequency estimater by least square fit with IC.

* Wed Aug 27 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.11-1)
- nmr/spectrumbase: IFT, padding for time domain.
- math/spectrumsolver: rectangular windowing for freq. estimation/MEM.
- sg: No serial poll before writing for HP.

* Thu Jul 10 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.10-1)
- nmr/spectrumbase: Fix for sparse acquision.
- dcsource: No serial poll for YK7651.

* Mon Jul 7 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.9-1)
- nmr/spectrumbase: Fix for sparse acquision.

* Tue Jul 1 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.8-1)
- math: Fix peak detections in spectrum solvers.
- nmr: Impliment digital IF. Catch errors of spectrum solvers.

* Fri Jun 27 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.7-2)
- kame.rules: For udev, ttyUSB*, ttyS*.
- charinterface.cpp: Fox for scanf().

* Sat Jun 21 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.7-1)
- Lecroy/Iwatsu X-Stream DSO.
- tds.cpp: Fix for trigger source.
- gpib.cpp: Fix for partial reading.

* Fri Feb 8 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.6-1)
- Sanwa PC500/5000.

* Fri Jan 25 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.5-1)
- spectrumsolver: Least-Square Phase Estimation.
- spectrumsolver: Combined MEM.

* Mon Jan 21 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.3-1)
- graphpainter: fix for selecting yaxis.
- nmrpulse, nmrspectrumbase, mem: Search for peaks.
- freqest: Freq. estimation. MUSIC.

* Tue Jan 15 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.2-1)
- math : new folder.
- FFTW ver 3.
- nmrspectrum : Abs. plot. Fix for handling weights.

* Fri Jan 11 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.1-2)
- nmrrelax : Convolution w/o FFT.

* Thu Jan 10 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.1-1)
- nmrrelax : Window. Auto-window. Direct Fourier.
- nmrspectrumbase : Its own FFT.

* Thu Jan 3 2008 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.3.0-1)
- nmrpulse, nmrspectrumbase : DSO plots, MEM/AR for DNR & spectra.
- nmrrelax.cpp : Im plot.

* Thu Nov 29 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.20-1)
- nmrpulse : rewrite DNR. Reflect extraAvg while increasing.

* Tue Nov 20 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.19-1)
- Fast read/write 64bit in 32bit machines.
- SSE2 by default.
- Rearrange main form.
- Fix for dead locks.

* Mon Nov 19 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.18-1)
- rubylineshell.
- pulserdrivercore: fix for pregating.

* Fri Nov 16 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.17-1)
- Replace admin dir.
- kame/Makefile.am: simplified.
- configure.in.in: fix for ruby.h.
- node browser.
- node: remember parent.
- nmrcore: merge sgcore and pulsercore.

* Sun Nov 11 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.16-1)
- secondarydriver: Improved stability regarding dead-locks.
- pulserdriver: Improved pre-gating.
- g++-4 for FTGL w/ -fpermissive.
- atomic_prv_x86.h: 64bit support.

* Mon Oct 22 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.15-1)
- network analyzers.
- nmrspectrum, nmrfspectrum: code refactoring & auto scale.

* Sat Oct 20 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.14-1)
- userdmm: HP3478A.

* Mon Sep 10 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.13-1)
- graph: Fix for autoscale faults.

* Sun Jul 29 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.12-2)
- pulserdriver: Arrange for FID.
- nmrrelax: St.E. mode. 2-parameter fitting.

* Fri Jul 27 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.12-1)
- pulserdriver: New option: conserve stimulated echo phase.

* Wed Jul 11 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.11-2)
- xwavengraph: Never use autoscale for weighting axes.

* Thu Jul 5 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.11-1)
- graph: Legends.

* Mon Jul 1 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.10-1)
- xwavengraph: New API for a single y-axis multi-plots.

* Thu Jun 28 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.9-1)
- nmrrelax: increase limit of samples.
- drver: visualize() after aborting.

* Tue Jun 26 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.8-2)
- recordreader: Use multi-thread for time sync again.
- nmrpulse: Much better phase-inversion-cycling.

* Mon Jun 25 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.8-1)
- recordreader: Use single thread for time sync.
- nidaqmx: Create objects w/o NIDAQmx.h somehow.

* Sun Jun 24 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.7-4)
- pulserdriver: Add QSW soft-switching-off functionality.

* Mon Jun 18 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.7-2)
- usertempcontrol: Fix Lakeshore340.
- nmrpulsernidaxmx: Never pause while ASW is active.
- levelmeter: ILM oxford helium level meter. LakeShore LM500 level meter.

* Wed Jun 13 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.7-1)
- usertempcontrol: Neocera LTC21.

* Mon Jun 11 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.6-2)
- rwlock.cpp: Fix for XRecursiveRWLock.

* Thu May 17 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.6-1)
- pulserdrivernidaqmx.cpp: Fix pausing feature for fast sps. Fix possible failure of synchronization.

* Wed May 16 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.5-2)
- nidaqmxdriver.cpp: NI-622x.

* Mon May 14 2007 Kentaro Kitagawa <kitag@issp.u-tokyo.ac.jp>
- (2.2.5-1)
- dcsource: YK7651 supports range.

* Wed Apr 18 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2.4-1)
- driver.h: Use try lock to avoid deadlocks.

* Tue Apr 14 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2.3-1)
- nmrpulse.cpp: Handle clear request correctly.
- dcsource: Multi-channel source.
- tempcontrol: Software PID.

* Tue Apr 10 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2.2-2)
- Disable spinlock.
- Fix montecarlo.

* Mon Apr 2 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2.2-1)
- Fix for the first software-trigger setup.
- Faster mutex.

* Sun Mar 18 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2.1-1)
- Fix nidaqmxpulser.
- Get rid of extra new line in xrubysupport.rb.

* Thu Mar 15 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.2-1)
- Dynamic module loading.
- packages: modules-standard (for general drivers with gpib, etc.),
	modules-nmr (NMR drivers), modules-nidaq (NI-DAQmx support).
- Fix SH2 pulser.

* Mon Mar 12 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.5-1)
- Ruby: $SAFE = 3 and begin .. rescue for loading .kame files.
- xnidaqmxpulser.cpp : increase buf size to 2sec.

* Sun Mar 11 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.4-1)
- Fixed TDS.
- Change xsignal.h API.
- Fix scheduler.

* Sat Mar 10 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.3-2)
- Fixed potential crash in nmrpulse.cpp.
- Roll phsase inversion cycle strategy back.

* Fri Mar 9 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.3-1)
- Fixed oxford drivers.
- Fixed phase inversion cycles.

* Tue Mar 7 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.2-4)
- Software trigger.
- Rewritten atomic stuffs.

* Fri Mar 2 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.2-3)
- Support for NI PCI-6115.

* Wed Feb 28 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.2-1)
- NIDAQmx support as NMR pulser and DSO.

* Sat Feb 3 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.0-3)
- introduce XCharDeviceDriver::{open(),close()}, XPrimaryDriver::afterStop()

* Fri Feb 2 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.1.0-2)
- chardevicedriver.h, oxforddriver.h : use such like XCharDeviceDriver<...> for driver w/ one character-based interface.

* Sun Jan 21 2007 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.13-2)
- kame.spec : modified for FedoraCore6.

* Wed Nov 1 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.12-2)
- xrubysupport.{cpp,rb} : Ignore errors on loading .kam.

* Mon Oct 30 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.12-1)
- driver : completely skip after XSkippedRecordError.
- dso, nmrpulse : move averaging rotation to nmrpulse.
- nmrpulse.cpp : Use inversion echoes to cancel background out.

* Wed May 24 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- pulserdriver : Q-Switch support.

* Sun May 14 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.11-1)
- nmrrelaxfit.cpp : more relaxation curves.
- usertempcontrol.cpp : fix crashing.
- support.cpp : new func. formatString().

* Fri May 12 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.10-4)
- Use mutex and deepcopy for i18n(). Use KAME::i18n() to redirect i18n().

* Thu May 11 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.10-3)
- XNIGPIBPort: fix the case for CMPL without END.
- primarydriver.cpp : fix for gcc-4.0

* Tue May 9 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.10-2)
- Switch to Fedra Core 5

* Wed May 3 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.10-1m)
- pulserdriversh.cpp : preliminary induced emission.
- get rid of QString stuff more.

* Tue Mar 7 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.9-1m)
- xnode.cpp, xlistnode.cpp, ... : Use RCU (Read-Copy-Update) to handle children.
- xlistnode.cpp : fix move().

* Sat Mar 5 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.8-1m)
- xlistnode.cpp : move(), change order.
- xnodeconnector.cpp : XListQConnector, dragging.

* Thu Mar 3 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.7-1m)
- bug fix. : Use QDeepCopy<QString> when needed.

* Thu Mar 2 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.6-1m)
- support.cpp : FormatDouble, Use "%.12g" as a default.
- xnode.h : Abondon childLock()/childUnlock().
- caltable.cpp : Display thermometer.

* Wed Mar 1 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.5-1m)
- cspline.cpp : cubic spline approximation.
- thermometer.cpp : new thermometer XApproxThermometer.
- xnodeconnector.cpp : fix display LCD.
- graphform.ui : derived from QMainWidget.
- xrubysupport.cpp : fix unnamed nodes.

* Tue Feb 28 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.4-1m)
- dso.cpp : FIR filter before recording.
- serial.cpp : change init. seq.
- userlockinamp.cpp : SR830 read freq on starting.
- tempcontrol.cpp : make single reading working.

* Sat Feb 11 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.3-2m)
- serial.cpp : revise checking of read count.
- support.cpp : use mutex for debug printings.
- pulserdriversh.cpp : sync with firm 1.2.

* Wed Feb 8 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.3-1m)
- serial.cpp : when read buffer is not empty before writing, throw instead of tcflush().

* Fri Feb 3 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.2-1m)
- dso.cpp, pulserdriver.cpp : change phase cycling sequences
	 and accumulate waves to correct averaging sterategy.

* Thu Feb 2 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0.1-1m)
- atomic_smart_fix.h : fix memory leak using CAS2.

* Wed Feb 1 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- atomic_queue.h : bug fix. uninitialized counter.

* Tue Jan 31 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- pulserdriver{sh,h8}.cpp : try to continue when turning-on is failed.
- atomic_smart_ptr.h : atomic_shared_ptr<>.compareAndSwap()

* Mon Jan 30 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-1.0.2m)
- atomic_smart_ptr.h : atomic_shared_ptr<>, lock-free scanning without CAS2.
- entrylistconnector.cpp : fix handling of transaction.
- analyzer.cpp : bug fix.
- atomic_queue.h : bug fix.

* Sun Jan 29 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-1.0.1m)
- atomic_queue.h : atomic queue, but reserved size is fixed.

* Fri Jan 27 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-1.0.1m)
- atomic.h, xtime.cpp : use assembly on powerPC as well.

* Thu Jan 26 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-1m)
- The first release of 2.0!
- Thanks for testers, Y. Ihara and Takeya.
- (bug) FTGL? : 2byte-chars cause crash.

* Tue Jan 24 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.8m)
- 2.0rc2
- xsignal.cpp : cease to read std::deque without mutex locking.
- atomic.h : atomic<>, memory barrierred wrapper to word-size type.
- todo : use QDeepCopy<QString> properly.

* Sat Jan 21 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- atomic_smart_ptr.h : atomic version of shared_ptr, scoped_ptr.
- fast_smart_ptr.h : faster version of shared_ptr, weak_ptr etc.
- xtime.h : timeStampInUsec(), use RDTSC in x86.
- XTalker<>::empty() : a hint to omit talking.

* Thu Jan 19 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- atomic_prv.h : atomicCompareAndSwap2(), 2 words CAS only for x86.
- atomic.h : implement wait-free atomic_shared_ptr<>. 2 words CAS is needed to make it wait-free.

* Wed Jan 18 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.7m)
- 2.0rc1
- driverlistconnector.cpp : onRecordRedirected() is moved to tcons,
	 because label (a member of tcons) must exist when the function is called. 
- atomic.h : atomic_scoped_ptr<> which supports atomic swap for destructive reading.
- atomic_prv.h : memoryBarrier() etc.
- xsignal.h : apply atomic_scoped_ptr<>, scoped_ptr<>.
	 Now argument is not shared among thransactions.
- graphpaintergl.cpp : Use QGLContext instead of QGLWidget.

* Tue Jan 17 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.6m)
- 2.0beta3
- atomic.h : various atomic operations. atomic_shared_ptr<>.
- xsignal.h : apply atomic_shared_ptr<>
- xnode.h : apply atomic_shared_ptr<>
- thread.h : XScopedLock<>, XScopedReadLock<>, XScopedWriteLock<>.
	better handlings of muteces.
- xnodeconnector.cpp : no need of XThreadLocal<> for containing shared_ptr.

* Fri Jan 13 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.5m)
- 2.0beta2
- xnode.cpp : use typeid() for getTypename()
- XML : xmlsupport is deprecated.
- configure : --with-malloc-debug option is added to use MallocDebug.app in MacOS X.
- kame.cpp : fix terrible memory leak.
- nmrrelaxfit.cpp : do_nlls(), fix memory leak.

* Thu Jan 12 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.4m)
- gpib.cpp : use wait before read, write.
- serial.cpp : time-out is enabled (3s).
- support.cpp : leak detector is enabled when boehm gc and libgccpp are avaliable.
	use class kame_gc as a base to detect leaks.
- xnode.cpp : definitions of XValueNode<> stuff is now in source.

* Mon Jan 9 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.3m)
- xnode.h : setValidator(), validator throws exception when input string is ill to convert
- support.h : formatDoubleValidator(), checks format string

* Sat Jan 7 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.2m)
- nmrfspectrum.cpp : new driver
- support.cpp: formatDouble(), cease to use qt's conversion from double to QString(),
	 because some versions of qt is buggy.

* Fri Jan 6 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9.1m)
- tools : script to make lite package which does not have NMR stuff.
- APIs : const modifiers.
- signalgenerator.cpp : new driver

* Wed Jan 4 2006 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (2.0-0.9m)
- 2.0beta1
- graphpaintergl.cpp : use UCS-4 instead of wchar_t for iconv to avoid locale dependency
- users/lia, users/magnetps, users/tempcontrol, most of users/nmr : ready
- support.cpp : impliment XKameError, base of exception classes
- driver : now GUI can create/release drivers
- interfacelistconnector.cpp : individual RUN/STOP button
- xwavengraph.cpp : change icon after the first dump.
- xnodeconnector.cpp : XFileStream is abadoned.
- i18n : in progress.
- APIs : fixed, i guess.

* Wed Dec 21 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- 2.0alpha2
- graph : Remove XChart
- analyzer, graph : use XDriver::time() as x axis of XValChart
- support.cpp : impliment formatDouble()
- XTextWriter : LastLine node

* Tue Dec 20 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- 2.0alpha1
- API : almost fixed
- all : revised, rewriten
- include FTGL tree for convrnience
- users/dmm, users/dso : ready
- graphwidget.cpp : TODO, event loop is busy while mouse is moving on

* Fri Oct 7 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.9-1m)
- Makefile.am : fix to be configured under the other dirs
- *.ui : fix for qt-3.3.5
- thermometers.{cpp,h} : New thermometer Scientific Instruments

* Wed Oct 5 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-16m)
- lockinamp : support freq. change
- AUTOHEADER may be autoheader-2.53 

* Thu Aug 13 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-14m)
- pulserdriversh.cpp : fix potential deadlock

* Thu Aug 13 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-13m)
- pulserdriversh.cpp : fix for long period (>60sec)
- kame : works with Mac OS X

* Thu Jan 22 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-12m)
- pulserdriver{h8, sh}.cpp : fix gate2 handlings for small tau

* Thu Jan 19 2005 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-11m)
- usertempcontrol.cpp: new driver: Cryo-con M32

* Thu Dec 13 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-10m)
- itcp.cpp: improve scheduling
- graph.cpp: avoid loop of redrawRequest

* Thu Dec 11 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-9m)
- itcp.cpp: Scheduling changed. Lock until old queue (>90 ms before)  gets cleared

* Thu Dec 11 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-8m)
- graph: bug fixes

* Thu Dec 10 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-7m)
- graph: reduce memory usage

* Thu Dec 10 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-6m)
- magnetps.cpp: PS w/o PCS supported
- graphpainter.cpp: quick help

* Thu Dec 10 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-5m)
- Kick out buggy QGLWidget::renderText. Apply FTGLPixmapFont instead.
- Mikachanfont which has no embeded fixed scale fonts is prefered.

* Thu Dec 6 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-4m)
- Gzip format is applied for raw stream binary

* Thu Dec 4 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-3m)
- support selection in 3D plot

* Thu Dec 1 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-2m)
- 3D plot functionality

* Thu Nov 29 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8.2-1m)
- 1.8.2
- support for OpenGL graphs, but still only for 2D plots

* Thu Nov 25 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8-2m)
- revise spec

* Thu Nov 25 2004 Kentaro Kitagawa <kitagawa@scphys.kyoto-u.ac.jp>
- (1.8-1m)
- The first release.